<?php

/**
 * File from https://prestashow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @authors     PrestaShow.pl <kontakt@prestashow.pl>
 * @copyright   2020 PrestaShow.pl
 * @license     https://prestashow.pl/license
 */

namespace Prestashow\PShowGallery\Model;

use Prestashow\PrestaCore\Model\AbstractModule;
use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Entity\PShowGalleryImage;
use Prestashow\PShowGallery\Entity\PShowGalleryHook;
use Configuration;
use Language;
use Db;
use Context;
use Media;
use Tools;
use Product;
use DOMDocument;
use Category;
use CMS;
use Validate;
use Hook;

abstract class Module extends AbstractModule
{
    const GALLERY_IMAGE = 'pshow/gallery/';
    
    const PSHOW_SIZE_OF_THUMB_DEFAULT = 1;
    const PSHOW_SIZE_OF_THUMB_OWN_WIDTH = 2;
    const PSHOW_SIZE_OF_THUMB_OWN_HEIGHT = 3;
    
    public $moduleVersionPath = array('2.4.0', '2.5.0', '2.7.0', '2.11.0', '2.12.0', '2.13.0', '2.14.0', '2.15.0');
    
    /**
     *  Add hooks here - it will be registered automatically
     */
    public $hooks = array(
        'header',
        'displayBackOfficeHeader',
        'PShowGalleryGetImages',
        'displayFooter',
        'PShowGalleryGetAlbums'
    );
    
    /**
     *  Module controllers with tab in admin menu
     */
    public $admin_menu_tab = 'PShowGalleryAlbum';
    
    /**
     *  Module controllers without tab in admin menu
     */
    public $controllers = array(
        'PShowGalleryBackup',
        'PShowGalleryUpdate',
        'PShowGalleryReportBug',
        'PShowGalleryHook',
        'PShowGalleryMain',
        'PShowGalleryImage',
        'albums',
        'album'
    );
    
    /**
     *  Primary configuration
     */
    public $name = 'pshowgallery';
    public $tab = 'front_office_features';
    public $version = '2.31.0';
    public $ps_versions_compliancy = array('min' => '1.5', 'max' => _PS_VERSION_);
    private $version_int = 231;
    
    public function __construct()
    {
        parent::__construct();
        
        $this->displayName = $this->l('PShow Gallery');
        $this->description = $this->l('Simple gallery module. Add albums, images and show them in your shop.');
    }
    
    public function install()
    {
        if (!parent::install())
            return false;
            
        if (version_compare(_PS_VERSION_, '1.5.6', '>='))
            $this->registerHook('moduleRoutes');
            
        $languages = Language::getLanguages();
        $result = array();
        foreach ($languages as $lang) {
            $result['page_name'][$lang['id_lang']] = $this->l('Gallery');
        }
            
        Configuration::updateValue('PSHOW_GALLERY_SIMPLE_SHOW', 1);
        Configuration::updateValue('PSHOW_GALLERY_SHARE_SHOW', 1);
        Configuration::updateValue('PSHOW_GALLERY_RIGHT_COLUMN', 0);
        Configuration::updateValue('PSHOW_GALLERY_PAGE_NAME', $result['page_name']);
        Configuration::updateValue('PSHOW_GALLERY_SEO_KEYWORD', $this->l('gallery'));
        
        $q = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album` (
            `id_pshow_gallery_album` INT(11) NOT NULL AUTO_INCREMENT ,
            `date_add` datetime NOT NULL ,
            `date_upd` datetime NOT NULL ,
            `cover` INT NOT NULL DEFAULT '0',
			`active` TINYINT(1) NOT NULL,
			`position` int(11) NOT NULL,
            PRIMARY KEY (`id_pshow_gallery_album`)
            ) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
                
        $q .= "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album_lang` (
            `id_pshow_gallery_album` INT(11) NOT NULL AUTO_INCREMENT,
            `id_lang` INT NOT NULL,
            `id_shop` int(11) NOT NULL,
            `name` TEXT NOT NULL,
			`link_rewrite` CHAR(128) NOT NULL,
            `description` TEXT NOT NULL,
            PRIMARY KEY (`id_pshow_gallery_album`, `id_lang`, `id_shop`)
            ) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
            
        $q .= "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album_shop` (
            `id_pshow_gallery_album` int(11) NOT NULL ,
            `id_shop` int(11) NOT NULL,
            PRIMARY KEY (`id_pshow_gallery_album`, `id_shop`)
            ) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
            
        $q .= "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_image` (
            `id_pshow_gallery_image` INT(11) NOT NULL AUTO_INCREMENT,
            `id_album` int(11) NOT NULL,
			`extension` VARCHAR(10) NOT NULL,
            `position` int(11) NOT NULL,
            `date_add` datetime NOT NULL,
            `date_upd` datetime NOT NULL,
            `active` TINYINT(1) NOT NULL,
			`cover` TINYINT(1) NULL,
            PRIMARY KEY (`id_pshow_gallery_image`, `id_album`)
            ) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
            
        $q .= "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_image_lang` (
            `id_pshow_gallery_image` INT(11) NOT NULL AUTO_INCREMENT,
            `id_lang` INT NOT NULL,
            `description` TEXT NOT NULL,
            PRIMARY KEY (`id_pshow_gallery_image`, `id_lang`)
            ) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
                
        $q .= 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pshow_gallery_tag` (
			  `id_pshow_gallery_tag` int(11) NOT NULL auto_increment,
			  `id_lang` int(11) DEFAULT NULL,
			  `name` varchar(45) DEFAULT NULL,
			  PRIMARY KEY (`id_pshow_gallery_tag`)
			) DEFAULT CHARSET=utf8, ENGINE=' . _MYSQL_ENGINE_ . '; ' ;
        
        $q .= 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pshow_gallery_album_tag` (
			  `id_pshow_gallery_tag` int(11) NOT NULL,
			  `id_pshow_gallery_album` int(11) DEFAULT NULL
			) DEFAULT CHARSET=utf8, ENGINE=' . _MYSQL_ENGINE_ . '; ' ;
                
        $q .= "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."pshow_gallery_hook` (
            `id_pshow_gallery_hook` INT(11) NOT NULL AUTO_INCREMENT ,
            `hook_name` text NOT NULL ,
            `presta_id_hook` INT NOT NULL ,
            `limit` INT NOT NULL DEFAULT '0',
            `id_album` INT NOT NULL DEFAULT '0',
            `hook_type` TEXT COLLATE utf8_polish_ci NOT NULL,
            `id_image` INT NOT NULL DEFAULT '0',
            `albums` text NOT NULL,
            `list_type` text NOT NULL,
            `thumb_cols` INT NOT NULL,
            `columns_width_xs` INT NOT NULL,
            `columns_width_sm` INT NOT NULL,
            `columns_width_md` INT NOT NULL,
            `columns_width_lg` INT NOT NULL,
            PRIMARY KEY (`id_pshow_gallery_hook`)
        ) DEFAULT CHARSET=utf8, ENGINE = "._MYSQL_ENGINE_."; ";
                
                
        $q .= "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "pshow_gallery_hook_lang` (
			`id_pshow_gallery_hook` INT(10) unsigned NOT NULL AUTO_INCREMENT ,
			`id_lang` INT(10) unsigned NOT NULL ,
			`title` text NULL ,
			PRIMARY KEY (`id_pshow_gallery_hook`, `id_lang`)
		) DEFAULT CHARSET=utf8, ENGINE = " . _MYSQL_ENGINE_ . "; ";
                
        Db::getInstance()->query($q);
        
        Configuration::deleteByName('PSHOW_GALLERY_IS_INSTALL');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_ALBUMS');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_LIST_TYPE');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_THUMB_COLS');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_ALBUMS_TAGS');
        Configuration::updateValue('PSHOW_GALLERY_VERSION', $this->version_int);
        
        return true;
    }
    
    public function getModuleId() {
        $q = "SELECT * FROM `" . _DB_PREFIX_ . "module` WHERE `name` = '" . getModuleName(__FILE__)."'";
        $wynik = Db::getInstance()->getRow($q);
        return $wynik["id_module"];
    }
    
    public function isHookRegister($nameOfHook) {
        if($this->getModuleId() != null) {
            $q = "SELECT * FROM `" . _DB_PREFIX_ . "hook` WHERE `name` = '" . $nameOfHook."'";
            $wynik = Db::getInstance()->getRow($q);
            $q = "SELECT * FROM `" . _DB_PREFIX_ . "hook_module` WHERE `id_hook` = " . $wynik["id_hook"]." AND `id_module` = " . $this->getModuleId();
            $wynik = Db::getInstance()->getRow($q);
            return ($wynik != null);
        }
        else {
            return false;
        }
    }
    
    public function uninstall()
    {
        if (!parent::uninstall())
            return false;
            
        Configuration::deleteByName('PSHOW_GALLERY_PAGE_NAME');
        Configuration::deleteByName('PSHOW_GALLERY_RIGHT_COLUMN');
        Configuration::deleteByName('PSHOW_GALLERY_SEO_KEYWORD');
        Configuration::deleteByName('PSHOW_GALLERY_SIMPLE_SHOW');
        Configuration::deleteByName('PSHOW_GALLERY_SHARE_SHOW');
        Configuration::deleteByName('PSHOW_GALLERY_IS_REGISTER_HOOK');
        Configuration::deleteByName('PSHOW_GALLERY_IMAGES_SORTED');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_ALBUMS');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_LIST_TYPE');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_THUMB_COLS');
        Configuration::deleteByName('PSHOW_GALLERY_IS_ADD_ALBUMS_TAGS');
        unset($_COOKIE["PSHOW_GALLERY_IMAGES_SORTED"]);
        
        $q = "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album_lang`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album_shop`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_image`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_image_lang`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_hook`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_pshowgallery_hook`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_hook_lang`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_album_tag`; ";
        $q .= "DROP TABLE IF EXISTS `" . _DB_PREFIX_ . "pshow_gallery_tag`; ";
        Db::getInstance()->query($q);
        Configuration::deleteByName('PSHOW_GALLERY_VERSION');
        
        return true;
    }
    
    public function hookModuleRoutes()
    {
        $seo_keyword = Configuration::get('PSHOW_GALLERY_SEO_KEYWORD');
        
        return array(
            'module-pshowgallery-albums' => array(
                'controller' => 'albums',
                'rule' => $seo_keyword,
                'keywords' => array(
                    'rewrite' => array('regexp' => '[_a-zA-Z0-9-\pL]*')
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'pshowgallery',
                    'controller' => 'albums'
                )
            ),
            'module-pshowgallery-album' => array(
                'controller' => 'album',
                'rule' => $seo_keyword . '/{id}/{rewrite}',
                'keywords' => array(
                    'id' => array('regexp' => '[0-9]+', 'param' => 'id'),
                    'rewrite' => array('regexp' => '[_a-zA-Z0-9-\pL]*')
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'pshowgallery',
                    'controller' => 'album'
                )
            )
        );
    }
    
    /**
     * Get album link
     *
     * @param int $id_album If null get albums main page
     * @return string URL
     */
    public static function getAlbumLink($id_album = null)
    {
        $context = Context::getContext();
        
        if ($id_album === null)
            return $context->link->getModuleLink('pshowgallery', 'albums');
            
            $album = new PShowGalleryAlbum((int)$id_album, $context->language->id, $context->shop->id);
            
            $link = $context->link->getModuleLink('pshowgallery', 'album', array(
                'id' => (int)$id_album,
                'rewrite' => $album->link_rewrite
            ));
            
            return $link;
    }
    
    public function hookDisplayHeader($params = array())
    {
        if(version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->context->controller->setMedia();
        }
        $this->context->controller->addJqueryPlugin('fancybox');
        $this->context->controller->addJqueryPlugin('bxslider');
        
        $this->context->controller->addCSS($this->_path . 'views/css/pshowgallery.css', 'all');
        
        if(version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->context->controller->addCSS($this->_path.'views/css/socialshare.css', 'all');
            $this->context->smarty->assign('isNewPresta', 1);
            Media::addJsDef(array('isNewPresta' => 1));
        }
        else {
            $this->context->controller->addCSS($this->_path.'views/css/socialshare_old.css', 'all');
        }
        $this->context->controller->addCSS($this->_path . 'views/css/gallerybox.css');
        $this->context->controller->addJS($this->_path . 'views/js/gallerybox.js');
        
        if (version_compare(_PS_VERSION_, '1.6', '<'))
            $this->context->controller->addCSS($this->_path . 'views/css/ps_15.css', 'all');
            
            $this->context->controller->addCSS($this->_path.'views/css/flaticon.css', 'all');
    }
    
    public function hookDisplayBackOfficeHeader($params) {
        if (strpos(Tools::getValue('controller'), 'PShowGallery') !== false)
        {
            $this->updateModule();
            $this->context->controller->setMedia();
            
            $this->context->controller->addJqueryPlugin('cooki-plugin');
            
            $this->context->controller->addCSS($this->_path.'views/css/admin.css', 'all');
        }
    }
    
    public function pobierzIndeksy($grupytext) {
        $wynik = @preg_split ( "/[,]+/", $grupytext );
        if ($wynik === false) {
            $wynik [0] = $grupytext;
        }
        return $wynik;
    }
    
    public function hookPShowGalleryGetAlbums($params = array())
    {
        if(version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->context->controller->setMedia();
        }
        $this->context->controller->addJquery();
        $this->context->controller->addJqueryUI(array(
            'ui.core',
            'ui.widget'
        ));
        
        $id_album = (isset($params['id_album']) && $params['id_album'] > 0 ? $this->pobierzIndeksy($params['id_album']) : false);
        $method = (isset($params['method']) && (!strcasecmp($params['method'], 'link') || !strcasecmp($params['method'], 'popup')) ? $params['method'] : (Configuration::get('PSHOW_GALLERY_SIMPLE_SHOW') ? 'popup' : 'link'));
        $title = (isset($params['title']) ? $params['title'] : false);
        $columns_width_xs = (isset($params['columns_width_xs']) && $params['columns_width_xs'] > 0 ? $params['columns_width_xs'] : 12);
        $columns_width_sm = (isset($params['columns_width_sm']) && $params['columns_width_sm'] > 0 ? $params['columns_width_sm'] : 6);
        $columns_width_md = (isset($params['columns_width_md']) && $params['columns_width_md'] > 0 ? $params['columns_width_md'] : 4);
        $columns_width_lg = (isset($params['columns_width_lg']) && $params['columns_width_lg'] > 0 ? $params['columns_width_lg'] : 4);
        $always_display_tags = (isset($params['always_display_tags']) ? $params['always_display_tags'] : false);
        
        if (!$id_album)
            return null;

            $this->context->controller->addCSS(__PS_BASE_URI__ . 'modules/pshowgallery/views/css/front_albums.css');
            
            for($i = 0; $i < count($id_album); $i++) {
                $albums[] = new PShowGalleryAlbum($id_album[$i], $this->context->language->id, $this->context->shop->id);
                $albums[count($albums)-1]->cover = (int)PShowGalleryImage::getCoverId($id_album[$i]);
                $images[$id_album[$i]] = PShowGalleryImage::getImages($this->context->language->id, $id_album[$i]);
            }
            
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . self::GALLERY_IMAGE;
            
            $this->context->smarty->assign("icon_album_link", $this->_path.'views/img/album-icon.png');
            $mobile_device = $this->context->getMobileDevice();
            
            $this->context->smarty->assign(array(
                'img_pub_path' => $img_pub_path,
                'albums' => $albums,
                'pshow_images' => $images,
                'columns_width_xs' => $columns_width_xs,
                'columns_width_sm' => $columns_width_sm,
                'columns_width_md' => $columns_width_md,
                'columns_width_lg' => $columns_width_lg,
                'method_link' => (!strcasecmp($method, 'link') ? true : false),
                'mobile_device' => $mobile_device,
                'always_display_tags' => $always_display_tags,
                'title' => $title
            ));
            
            return $this->display(__FILE__.'/../../pshowgallery.php', 'views/templates/hook/getAlbums.tpl');
    }
    
    public function hookPShowGalleryGetImages($params = array())
    {
        $limit = (isset($params['limit'])) && $params['limit'] > 0 ? (int) $params['limit'] : 3;
        $id_album = (isset($params['id_album'])) && $params['id_album'] > 0 ? (int) $params['id_album'] : false;
        $album = new PShowGalleryAlbum($id_album, $this->context->language->id, $this->context->shop->id);
        $album->cover = (int) PShowGalleryImage::getCoverId($album->id_pshow_gallery_album);
        $id_image = (isset($params['id_image'])) && $params['id_image'] > 0 ? (int) $params['id_image'] : false;
        $columns_width_xs = (isset($params['columns_width_xs']) && $params['columns_width_xs'] > 0 ? $params['columns_width_xs'] : 12);
        $columns_width_sm = (isset($params['columns_width_sm']) && $params['columns_width_sm'] > 0 ? $params['columns_width_sm'] : 6);
        $columns_width_md = (isset($params['columns_width_md']) && $params['columns_width_md'] > 0 ? $params['columns_width_md'] : 4);
        $columns_width_lg = (isset($params['columns_width_lg']) && $params['columns_width_lg'] > 0 ? $params['columns_width_lg'] : 4);
        $title = (isset($params['title']) ? $params['title'] : false);
        $isSlider = (isset($params['isSlider']) ? $params['isSlider'] : false);
        $id_slider = (isset($params['id_slider']) ? $params['id_slider'] : false);
        
        $id_category = (isset($params['id_category'])) && $params['id_category'] > 0 ? (int) $params['id_category'] : false;
        $id_product = (isset($params['id_product'])) && $params['id_product'] > 0 ? (int) $params['id_product'] : false;
        $showInProduct = isset($params['showInProduct']) ? $params['showInProduct'] : false;
        $showInCategory = isset($params['showInCategory']) ? $params['showInCategory'] : false;
        $always_display_tags = (isset($params['always_display_tags']) ? $params['always_display_tags'] : false);
        
        $showGallery = false;
        $id_category_shop = (int) Tools::getValue('id_category');
        $id_product_shop = (int) Tools::getValue('id_product');
        
        if($showInCategory && $id_category_shop)
        {
            if($id_category && $id_category == $id_category_shop)
            {
                $showGallery = true;
            }
        }
        else if($showInProduct && $id_product_shop)
        {
            if($id_product && $id_product == $id_product_shop)
            {
                $showGallery = true;
            }
            else if($id_category)
            {
                $categories_temp = Product::getProductCategories($id_product_shop);
                if(in_array($id_category, $categories_temp))
                {
                    $showGallery = true;
                }
            }
        }
        else if(!$showInCategory && !$showInProduct)
        {
            $showGallery = true;
        }
        
        if($showGallery)
        {
            if ($id_image) {
                $images = PShowGalleryImage::getImage($this->context->language->id, $id_image);
            }
            else if ($id_album) {
                $images = PShowGalleryImage::getImages($this->context->language->id, $id_album);
            }
            else {
                return null;
            }
            
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . self::GALLERY_IMAGE;
            
            $mobile_device = $this->context->getMobileDevice();
            
            if(version_compare(_PS_VERSION_, '1.7.0', '>=')) {
                $this->context->smarty->assign('get_import_js', 1);
                $this->context->smarty->assign('address', $_SERVER['DOCUMENT_ROOT'].__PS_BASE_URI__);
            }
            else {
                $this->context->smarty->assign('get_import_js', 0);
            }
            
            $this->context->smarty->assign(array(
                'img_pub_path' => $img_pub_path,
                'pshow_images' => $images,
                'album' => $album,
                'simple_show' => Configuration::get('PSHOW_GALLERY_SIMPLE_SHOW'),
                'limit' => $limit,
                'active' => $album->active,
                'id_album' => $id_album,
                'columns_width_xs' => $columns_width_xs,
                'columns_width_sm' => $columns_width_sm,
                'columns_width_md' => $columns_width_md,
                'columns_width_lg' => $columns_width_lg,
                'always_display_tags' => $always_display_tags,
                'title' => $title,
                'isSlider' => $isSlider,
                'id_slider' => $id_slider,
                'share_show' => Configuration::get('PSHOW_GALLERY_SHARE_SHOW'),
                'mobile_device' => $mobile_device
            ));
            
            return $this->display(__FILE__.'/../../pshowgallery.php', 'views/templates/hook/getImages.tpl');
        }
        else
        {
            return "";
        }
    }
    
    public function hookDisplayFooter($params = array())
    {
        $content_limit = (isset($params['content_limit']) ? $params['content_limit'] : false);
        $method = (isset($params['method']) && ($params['method'] == 'link' || $params['method'] == 'popup') ? $params['method'] : 'link');
        $title = (isset($params['title']) ? $params['title'] : false);
        
        $album_url = __PS_BASE_URI__ . "?fc=module&module=pshowgallery&controller=album&id_album=";
        
        $doc = new DOMDocument();
        
        $id_product = (int)Tools::getValue("id_product");
        $id_category = (int)Tools::getValue("id_category");
        $id_cms = (int)Tools::getValue("id_cms");
        $images = array();
        $albums = array();
        if($id_product && Configuration::get("PSHOW_GALLERY_PRODUCT_PAGE_ASSOCIATIONS"))
        {
            $product = new Product($id_product, $this->context->language->id);
            $result = $product->getTags($this->context->language->id);
            $albums_items = PShowGalleryAlbum::getFullAlbumsByTags($result, $this->context->language->id, $this->context->shop->id);
            
            foreach($albums_items as $albums_item) {
                $albums[] = new PShowGalleryAlbum($albums_item["id_pshow_gallery_album"], $this->context->language->id, $this->context->shop->id);
                $albums[count($albums)-1]->cover = (int)PShowGalleryImage::getCoverId($albums_item["id_pshow_gallery_album"]);
                $images[$albums_item["id_pshow_gallery_album"]] = PShowGalleryImage::getImages($this->context->language->id, $albums_item["id_pshow_gallery_album"]);
            }
            
            $this->context->smarty->assign(array(
                'content_limit' => $content_limit,
                'albums' => $albums,
                'album_url' => $album_url,
                'pshow_images' => $images,
                'doc' => $doc,
                'title' => $title
            ));
            
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . self::GALLERY_IMAGE;
            
            $this->context->smarty->assign("icon_album_link", $this->_path.'views/img/album-icon.png');
            
            $this->context->smarty->assign(array(
                'img_pub_path' => $img_pub_path,
                'method_link' => ($method == 'link' ? true : false)
            ));
            
            return $this->display(__FILE__.'/../../pshowgallery.php', 'views/templates/hook/footerAlbums.tpl');
        }
        else if($id_category && Configuration::get("PSHOW_GALLERY_CATEGORY_PAGE_ASSOCIATIONS"))
        {
            $category = new Category($id_category, $this->context->language->id);
            $result = $category->meta_keywords;
            $albums_items = PShowGalleryAlbum::getFullAlbumsByTags($result, $this->context->language->id, $this->context->shop->id);
            
            foreach($albums_items as $albums_item) {
                $albums[] = new PShowGalleryAlbum($albums_item["id_pshow_gallery_album"], $this->context->language->id, $this->context->shop->id);
                $albums[count($albums)-1]->cover = (int)PShowGalleryImage::getCoverId($albums_item["id_pshow_gallery_album"]);
                $images[$albums_item["id_pshow_gallery_album"]] = PShowGalleryImage::getImages($this->context->language->id, $albums_item["id_pshow_gallery_album"]);
            }
            
            $this->context->smarty->assign(array(
                'content_limit' => $content_limit,
                'albums' => $albums,
                'album_url' => $album_url,
                'images' => $images,
                'doc' => $doc,
                'title' => $title
            ));
            
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . self::GALLERY_IMAGE;
            
            $this->context->smarty->assign("icon_album_link", $this->_path.'views/img/album-icon.png');
            
            $this->context->smarty->assign(array(
                'img_pub_path' => $img_pub_path,
                'method_link' => ($method == 'link' ? true : false)
            ));
            
            return $this->display(__FILE__.'/../../pshowgallery.php', 'views/templates/hook/footerAlbums.tpl');
        }
        else if($id_cms && Configuration::get("PSHOW_BLOG_GALLERY_PAGE_ASSOCIATIONS"))
        {
            $cms = new CMS($id_cms, $this->context->language->id);
            $result = $cms->meta_keywords;
            $albums_items = PShowGalleryAlbum::getFullAlbumsByTags($result, $this->context->language->id, $this->context->shop->id);
            
            foreach($albums_items as $albums_item) {
                $albums[] = new PShowGalleryAlbum($albums_item["id_pshow_gallery_album"], $this->context->language->id, $this->context->shop->id);
                $albums[count($albums)-1]->cover = (int)PShowGalleryImage::getCoverId($albums_item["id_pshow_gallery_album"]);
                $images[$albums_item["id_pshow_gallery_album"]] = PShowGalleryImage::getImages($this->context->language->id, $albums_item["id_pshow_gallery_album"]);
            }
            
            $this->context->smarty->assign(array(
                'content_limit' => $content_limit,
                'albums' => $albums,
                'album_url' => $album_url,
                'images' => $images,
                'doc' => $doc,
                'title' => $title
            ));
            
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . self::GALLERY_IMAGE;
            
            $this->context->smarty->assign("icon_album_link", $this->_path.'views/img/album-icon.png');
            
            $this->context->smarty->assign(array(
                'img_pub_path' => $img_pub_path,
                'method_link' => ($method == 'link' ? true : false)
            ));
            
            return $this->display(__FILE__.'/../../pshowgallery.php', 'views/templates/hook/footerAlbums.tpl');
        }
    }
    
    public function __call($method, $args = array())
    {
        $hook_name = str_replace('hook', '', $method);
        
        if (!Validate::isHookName($hook_name))
            return false;
            
            if (!class_exists('PShowGalleryHook'))
                require_once dirname(__FILE__) . "/../../config.php";
                
                $id_hook = PShowGalleryHook::getHookIdByPrestaHookName($hook_name);
                
                $hook = new PShowGalleryHook($id_hook, $this->context->cookie->id_lang);
                
                if (!is_object($hook))
                    return false;
                    
                    $result = "";
                    
                    if($hook->hook_type === "albums")
                    {
                        $result = $this->hookPShowGalleryGetAlbums(array(
                            'id_album' => $hook->albums,
                            'columns_width_xs' => $hook->columns_width_xs,
                            'columns_width_sm' => $hook->columns_width_sm,
                            'columns_width_md' => $hook->columns_width_md,
                            'columns_width_lg' => $hook->columns_width_lg,
                            'title' => $hook->title
                        ));
                    }
                    else
                    {
                        $result = $this->HookPShowGalleryGetImages(array(
                            'id_album' => $hook->id_album,
                            'id_image' => $hook->id_image,
                            'limit' => $hook->limit,
                            'title' => $hook->title,
                            'columns_width_xs' => $hook->columns_width_xs,
                            'columns_width_sm' => $hook->columns_width_sm,
                            'columns_width_md' => $hook->columns_width_md,
                            'columns_width_lg' => $hook->columns_width_lg,
                            'isSlider' => ($hook->list_type === 'list' ? true : false),
                            'id_slider' => $hook->id
                        ));
                    }
                    
                    if (strpos($hook_name, 'display') !== false)
                        return $result;
                        else
                            echo $result;
                            
                            return true;
    }
    
    public static function getHooksFromContent($content)
    {
        $matches = array();
        
        // get all hooks from content
        preg_match_all('~\{hook ([^};]+)\}~', $content, $matches);
        
        $hook_properties = $matches[1];
        
        $i = 0;
        
        foreach ($hook_properties as $hp)
        {
            $properties = array();
            
            // get hook properties
            preg_match_all('~([a-zA-Z0-9\-\_]+)=([a-zA-Z0-9\-\_,\"\']+)~', $hp, $properties);
            
            $keys = $properties[1];
            $values = $properties[2];
            $hook_args = array();
            
            // create array of arguments
            $count_keys = count($keys);
            for ($x = 0; $x < $count_keys; ++$x)
            {
                $keys[$x] = str_replace(array('"', "'"), "", $keys[$x]);
                $values[$x] = str_replace(array('"', "'"), "", $values[$x]);
                
                $hook_args[$keys[$x]] = $values[$x];
            }
            
            $mod = null;
            
            if (isset($hook_args['mod']))
            {
                $mod = Module::getModuleIdByName($hook_args['mod']);
                unset($hook_args['mod']);
            }
            
            // exec hook
            $hook = Hook::exec($hook_args['h'], $hook_args, $mod, false, true, false, null);
            
            // replace hook entry on hook content
            $content = str_replace($matches[0][$i], $hook, $content);
            
            unset($hook);
            
            ++$i;
        }
        
        // return new content
        return $content;
    }
    
    /**
     * Copy all images from module folder
     */
    private function recurseCopy($source, $destination)
    {
        if (!file_exists($destination))
            mkdir($destination, 0777, true);
            
            $dir = opendir($source);
            
            while(false !== ($file = readdir($dir)))
            {
                if (($file != '.') && ($file != '..'))
                {
                    if (is_dir($source . '/' . $file)) {
                        $this->recurse_copy($source . '/' . $file, $destination . '/' . $file);
                    }
                    else {
                        copy($source . '/' . $file, $destination . '/' . $file);
                    }
                }
            }
            
            closedir($dir);
    }
    
    public static function canonicalRedirection($canonical_url = '')
    {
        if (!$canonical_url || !Configuration::get('PS_CANONICAL_REDIRECT') ||
            strtoupper($_SERVER['REQUEST_METHOD']) != 'GET' || Tools::getValue('live_edit')) {
                return;
            }
            
            $match_url = rawurldecode(Tools::getCurrentUrlProtocolPrefix() . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
            if (!preg_match('/^' . Tools::pRegexp(rawurldecode($canonical_url), '/') . '([&?].*)?$/', $match_url)) {
                $params = array();
                $url_details = parse_url($canonical_url);
                
                if (!empty($url_details['query'])) {
                    parse_str($url_details['query'], $query);
                    foreach ($query as $key => $value) {
                        $params[Tools::safeOutput($key)] = Tools::safeOutput($value);
                    }
                }
                $excluded_key = array('id', 'module', 'isolang', 'id_lang',
                    'controller', 'fc', 'id_product', 'id_category', 'id_manufacturer',
                    'id_supplier', 'id_cms');
                foreach ($_GET as $key => $value) {
                    if (!in_array($key, $excluded_key) && Validate::isUrl($key) && Validate::isUrl($value)) {
                        $params[Tools::safeOutput($key)] = Tools::safeOutput($value);
                    }
                }
                
                $str_params = http_build_query($params, '', '&');
                if (!empty($str_params)) {
                    $final_url = preg_replace('/^([^?]*)?.*$/', '$1', $canonical_url) . '?' . $str_params;
                } else {
                    $final_url = preg_replace('/^([^?]*)?.*$/', '$1', $canonical_url);
                }
                
                // Don't send any cookie
                Context::getContext()->cookie->disallowWriting();
                
                if (defined('_PS_MODE_DEV_') && _PS_MODE_DEV_ && $_SERVER['REQUEST_URI'] != __PS_BASE_URI__) {
                    die('[Debug] This page has moved<br />Please use the following URL instead: <a href="' . $final_url . '">' . $final_url . '</a>');
                }
                
                $redirect_type = Configuration::get('PS_CANONICAL_REDIRECT') == 2 ? '301' : '302';
                header('HTTP/1.0 ' . $redirect_type . ' Moved');
                header('Cache-Control: no-cache');
                Tools::redirectLink($final_url);
            }
    }
}