﻿<?php
use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_'))
{
  exit;
}

class hotpayPRZELEWY extends PaymentModule
{
  public function __construct()
  {
    $this->name = 'hotpayPRZELEWY';
    $this->tab = 'payments_gateways';
    $this->version = '1.0.1';
    $this->author = 'Piotr Żygowski';
    $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
    $this->bootstrap = true;
    $this->is_eu_compatible = 1;

    $this->currencies = true;
    $this->currencies_mode = 'checkbox';

    parent::__construct();

    $this->displayName = $this->l('Hotpay Przelewy');
    $this->description = $this->l('Płatności szybkich przelewów dla prestashop.');

    $this->confirmUninstall = $this->l('Czy na pewno chcesz usunąć płatności przelewami?');

    if (!Configuration::get('hotpayPRZELEWY'))
      $this->warning = $this->l('No name provided');
  }



   public function install()
    {
         if (!parent::install() || !$this->registerHook('paymentOptions') || !$this->registerHook('paymentReturn')) {
            return false;
        }

        Configuration::updateValue('hotpayPRZELEWY_SEKRET', "");
        Configuration::updateValue('hotpayPRZELEWY_HASH_TAJNY', "");
       


        return true;

    }

    public function isPropValid($prop)
    {
        return $prop && !empty($prop);
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);
        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }
    public function hookPaymentOptions($params)
    {

        if (!$this->active) {
            return;
        }
        if (!$this->checkCurrency($params['cart'])) {
            return;
        }
     
        $payment_options = [
            $this->getExternalPaymentOption($params),
        ];

       
        return $payment_options;               
    }

    

    public function getContent()
    {
     global $smarty;
    $output="";
    if(!empty($_POST["hotpayPRZELEWY_SEKRET"]) && !empty($_POST["hotpayPRZELEWY_SEKRET"])){
      Configuration::updateValue('hotpayPRZELEWY_HASH_TAJNY', $_POST["hotpayPRZELEWY_HASH_TAJNY"]);
      Configuration::updateValue('hotpayPRZELEWY_SEKRET', $_POST["hotpayPRZELEWY_SEKRET"]);
    

    
      $output .= $this->displayConfirmation($this->l('Ustawienia zaktualizowane.'));
    }



      $output.='

<div class="bootstrap">
        <div class="alert alert-warning">
          
             Adres do wysyłania notyfikacji: '. _PS_BASE_URL_.__PS_BASE_URI__.'index.php?fc=module&module=hotpayPRZELEWY&controller=notyfikacje</div>
        </div>
      ';
    
    $output.=$this->renderForm();
     
        return $output;
    }

 public function renderForm()
    {

        // Get default language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
    
        // Init Fields form array
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Aktualizuj ustawienia szybkich przelewów'),
            ),
            'input' => array(
                array(
                        'type' => 'text',
                        'label' => 'Sekret usługi',
                        'name' => 'hotpayPRZELEWY_SEKRET',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => 'Tajne hasło',
                        'name' => 'hotpayPRZELEWY_HASH_TAJNY',
                        'required' => true
                      

                    )
              
            ),
            'submit' => array(
                'title' => $this->l('Aktualizuj'),
                'class' => 'btn btn-default pull-right'
            )
        );
    
        $helper = new HelperForm();
    
        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
    
        // Language
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        $helper->submit_action = 'btnSubmit';
        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;        // false -> remove toolbar
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' =>
            array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                '&token='.Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );
       
        $helper->fields_value['hotpayPRZELEWY_SEKRET'] = Configuration::get('hotpayPRZELEWY_SEKRET');
        $helper->fields_value['hotpayPRZELEWY_HASH_TAJNY'] = Configuration::get('hotpayPRZELEWY_HASH_TAJNY');
   

        return $helper->generateForm($fields_form);
    }




    public function getExternalPaymentOption($params)
    {


        $externalOption = new PaymentOption();

        $externalOption->setCallToActionText($this->l('Zapłać Szybkim Przelewem'))
             ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
             ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/logo.png'));

         //$externalOption->setInputs($postfields);





        return $externalOption;
    }

  






}
