<?php

/**
 * File from https://prestashow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @authors     PrestaShow.pl <kontakt@prestashow.pl>
 * @copyright   2020 PrestaShow.pl
 * @license     https://prestashow.pl/license
 */

namespace Prestashow\PShowGallery\Controller;

use Prestashow\PrestaCore\Model\AbstractAdminController;
use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Entity\PShowGalleryImage;
use Prestashow\PShowGallery\Entity\PShowGalleryHook;
use Prestashow\PShowGallery\Model\Module;
use Prestashow\PrestaCore\Entity\Hook as PrestaCoreHook;
use Tools;
use Context;
use PrestaShopException;
use Validate;
use Hook;

class BHookController extends AbstractAdminController {
    
    public $default_action = 'list';
    public $select_menu_tab = 'subtab-PShowGalleryMain';
    
    public function __construct()
    {
        $this->table = 'pshow_gallery_hook';
        $this->className = '\Prestashow\PShowGallery\Entity\PShowGalleryHook';
        $this->lang = true;
        $this->_defaultOrderBy = 'id_pshow_gallery_hook';
        $this->_defaultOrderWay = 'ASC';
        
        $this->context = Context::getContext();
        
        parent::__construct();
        
        $this->controller_displayName = $this->l('Hooks');
        $this->toolbar_title = $this->l('Hooks');
        
        $this->specificConfirmDelete = $this->l('Delete this hook?');
        
        $this->fields_list = array(
            'id_pshow_gallery_hook' => array(
                'title' => $this->l('ID'),
                'align' => 'center',
                'class' => 'fixed-width-xs'
            ),
            'hook_name' => array(
                'title' => $this->l('Hook name')
            ),
            'info' => array(
                'title' => $this->l('Additional info')
            )
        );
        
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        
        $this->tpl_folder = 'galleryhook/';
        $this->img_pub_path = _PS_IMG_ . Module::GALLERY_IMAGE;
    }
    
    public function getList($id_lang, $order_by = null, $order_way = null, $start = 0, $limit = null, $id_lang_shop = false)
    {
        parent::getList($id_lang, $order_by, $order_way, $start, $limit, $id_lang_shop);
        
        foreach ($this->_list as &$list)
        {
            $list['album'] = new PShowGalleryAlbum($list['id_album'], $id_lang);
            
            if ($list['hook_type'] == 'image')
                $list['info'] = $this->l('Image');
                else if ($list['hook_type'] == 'albums')
                    $list['info'] = $this->l('Ablums') . ': ' . $list['albums'];
                    else
                        $list['info'] = $this->l('Ablum') . ': ' . $list['album']->name . ' (' . $this->l('limit') . ': ' . $list['limit'] . ')';
        }
    }
    
    public function renderList()
    {
        $this->action_displayName = $this->l('Hooks');
        
        return parent::renderList();
    }
    
    public function postProcess()
    {
        $id_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        
        if (Tools::getValue('ajax'))
        {
            $images = PShowGalleryImage::getImages($id_lang, Tools::getValue('id_album'), $id_shop);
            $result = array();
            
            foreach ($images as $image)
                $result['images'][] = array(
                    'id' => $image['id_pshow_gallery_image'],
                    'name' => $image['title']
                );
                
                $result['checked'] = PShowGalleryHook::getIdImageByIdAlbum(Tools::getValue('id_album'));
                
                die(Tools::jsonEncode($result));
        }
        
        if (Tools::isSubmit('submitAdd' . $this->table))
        {
            try
            {
                $hook_name = Tools::getValue('hook_name');
                
                // if ID exists action == update
                if ($this->id_object)
                    PrestaCoreHook::unregisterHook('pshowgallery', $hook_name, $id_shop);
                    
                    $presta_hook = PrestaCoreHook::isHookRegistered('pshowgallery', $hook_name, $id_shop);
                    if(!$presta_hook)
                        $presta_id_hook = PrestaCoreHook::registerHook('pshowgallery', $hook_name, $id_shop);
                        else
                            $presta_id_hook = $presta_hook['id_hook'];
                            
                            // save $presta_id_hook for process
                            $_POST['presta_id_hook'] = (int)$presta_id_hook;
                            
                            if (Tools::getValue('hook_type') == 'album')
                                $_POST['id_image'] = 0;
                                
                                
                                $albums = array();
                                foreach (PShowGalleryAlbum::getAlbums($id_lang, $id_shop, true) as $album)
                                    if (Tools::getValue('albums_'.$album->id_pshow_gallery_album))
                                        $albums[] = $album->id_pshow_gallery_album;
                                        
                                        if(count($albums) > 0)
                                        {
                                            $_POST['albums'] = implode(',', $albums);
                                        }
                                        
                                        parent::postProcess();
                                        
            } catch (PrestaShopException $e) {
                $e->displayMessage();
                $this->alerts[] = array('warning', $this->l('Hook add error, try again'));
            }
        }
        
        if ($this->action == 'delete')
        {
            $id_hook = Tools::getValue('id_pshow_gallery_hook');
            $hook = new PShowGalleryHook($id_hook);
            
            PrestaCoreHook::unregisterHook('pshowgallery', $hook->hook_name, $id_shop);
            
            parent::postProcess();
        }
    }
    
    public function renderForm()
    {
        $this->action_displayName = $this->l('Edit hook');
        
        $id_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        
        $hooks = Hook::getHooks();
        $hooks = $this->prepareHooksList($hooks);
        
        $albums = PShowGalleryAlbum::getAlbums($id_lang, $id_shop, true);
        $albums_array = PShowGalleryAlbum::getAlbums($id_lang, $id_shop, false);
        
        $columns_width = array();
        for($i = 12; $i >= 1; $i--)
            $columns_width[] = array(
                'id' => $i,
                'name' => $i.'/12'
            );
            
            $this->fields_form = array(
                'legend' => array(
                    'title' => $this->l('Hook')
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'label' => $this->l('Hook'),
                        'name' => 'hook_name',
                        'required' => true,
                        'options' => array(
                            'query' => $hooks,
                            'id' => 'name',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Title'),
                        'name' => 'title',
                        'lang' => true,
                        'hint' => $this->l('HTML Available'),
                        'desc' => $this->l('Set the title for the displayed block.')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('What you want to display'),
                        'name' => 'hook_type',
                        'required' => true,
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => 'albums',
                                    'name' => $this->l('Albums')
                                ),
                                array(
                                    'id' => 'album',
                                    'name' => $this->l('Album')
                                ),
                                array(
                                    'id' => 'image',
                                    'name' => $this->l('Image')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Show list of images as list or grid'),
                        'name' => 'list_type',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => 'list',
                                    'name' => $this->l('List')
                                ),
                                array(
                                    'id' => 'grid',
                                    'name' => $this->l('Grid')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'checkbox',
                        'label' => $this->l('Select albums to show'),
                        'name' => 'albums',
                        'class' => 'albums-categories',
                        'hint' => $this->l('Display this albums.'),
                        'values' => array(
                            'query' => $albums_array,
                            'id' => 'id_pshow_gallery_album',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Album'),
                        'name' => 'id_album',
                        'required' => true,
                        'options' => array(
                            'query' => $albums,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Images limit to display'),
                        'hint' => $this->l('If the limit is set to zero will display all entries.'),
                        'name' => 'limit',
                        'required' => true,
                        'size' => 10,
                        'default_value' => 1
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Columns xs count'),
                        'hint' => $this->l('The number of bootstrap xs columns per image.'),
                        'name' => 'columns_width_xs',
                        'options' => array(
                            'query' => $columns_width,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Columns sm count'),
                        'hint' => $this->l('The number of bootstrap sm columns per image'),
                        'name' => 'columns_width_sm',
                        'options' => array(
                            'query' => $columns_width,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Columns md count'),
                        'hint' => $this->l('The number of bootstrap md columns per image'),
                        'name' => 'columns_width_md',
                        'options' => array(
                            'query' => $columns_width,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Columns lg count'),
                        'hint' => $this->l('The number of bootstrap lg columns per image'),
                        'name' => 'columns_width_lg',
                        'options' => array(
                            'query' => $columns_width,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'album_images',
                        'label' => $this->l('Image to display'),
                        'name' => 'id_image',
                        'required' => true
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save')
                )
            );
            
            $this->context->smarty->assign('img_pub_path', $this->img_pub_path);
            
            $this->fields_value = $this->getConfiguration();
            
            return  parent::renderForm();
    }
    
    public function getConfiguration()
    {
        $id_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        $fields = array();
        $obj = $this->loadObject(true);
        if(Validate::isLoadedObject($obj))
        {
            foreach (explode(",", $obj->albums) as $album)
            {
                if($album)
                {
                    $fields["albums_".$album] = true;
                }
            }
        }
        
        return $fields;
    }
    
    public function prepareHooksList($hooks)
    {
        foreach ($hooks as $key => $value)
        {
            if ((stripos($value['name'], 'action') !== false)
                || (stripos($value['name'], 'admin') !== false)
                || (stripos($value['name'], 'backoffice') !== false)
                || (stripos($value['name'], 'dashboard') !== false))
            {
                unset($hooks[$key]);
            }
        }
        
        return $hooks;
    }
    
    // Temporary bypass functions
    public function listHelperAction() {}
    public function addHelperAction() {}
    public function newHelperAction() {}
    public function editHelperAction() {}
}
