<?php
namespace PayPal\EBLBaseComponents;

use PayPal\Core\PPXmlMessage;

/**
 * Base type definition of request payload that can carry any
 * type of payload content with optional versioning information
 * and detail level requirements.
 */
class AbstractRequestType
  extends PPXmlMessage
{

    /**
     * This specifies the required detail level that is needed by a
     * client application pertaining to a particular data component
     * (e.g., Item, Transaction, etc.). The detail level is
     * specified in the DetailLevelCodeType which has all the
     * enumerated values of the detail level for each component.
     * @array
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $DetailLevel;

    /**
     * This should be the standard RFC 3066 language identification
     * tag, e.g., en_US.
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $ErrorLanguage;

    /**
     * This refers to the version of the request payload schema.
     * @access    public
     * @namespace ebl
     * @var string
     */
    public $Version;

}
