{extends file='page.tpl'}
{block name='content'}
    {if !isset($errors) || !$errors}
        <div class="pshowgallery">
            <section class="album">
                <section class="album-list">
                    <div class="left-arrow-container">
                        <i class="material-icons">&#xe314;</i>
                    </div>
                    <div class="album-container album-scroller">
                        <div class="get-back-to-albums-container">
                            <a href="{$link->getModuleLink('pshowgallery', 'albums')}"
                               title="Go back to the album list">
                                <i class="material-icons">filter</i>
                            </a>
                            <h5>{l s='Back'}</h5>
                        </div>
                        {foreach from=$albums item='albums_item'}
                            <div class="album-item {if $albums_item->id == $album->id}selected-album{/if}">
                                <div class="pshowgallerybox">
                                    <div class="album-front-img">
                                        <a href="{PShowGallery::getAlbumLink($albums_item->id)}" class="text-center"
                                           title="{$albums_item->name}">
                                            <img itemprop="image"
                                                 src="{$img_pub_path}thumb_{\Prestashow\PShowGallery\Entity\PShowGalleryImage::getCoverId($albums_item->id)}.jpg"
                                                 title="{$albums_item->name}" alt="{$albums_item->name}"
                                                 class="img-responsive">
                                        </a>
                                    </div>
                                    <div class="title-of-album">
                                        <h5><span>{$albums_item->name}</span></h5>
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    </div>
                    <div class="right-arrow-container">
                        <i class="material-icons">&#xe315;</i>
                    </div>
                </section>
            </section>
            <div class="album-list-item">
                {foreach from=$images item='image'}
                    <div class="album-single-item">
                        <a href="{$img_pub_path}{$image['id_pshow_gallery_image']}.{$image['extension']}"
                           title="{if $image['description']}{$image['description']}{else}{$album->name}{/if}">
                            <img itemprop="image" src="{$img_pub_path}thumb_{$image['id_pshow_gallery_image']}.jpg"
                                 title="{if $image['description']}{$image['description']}{else}{$album->name}{/if}"
                                 alt="{if $image['description']}{$image['description']}{else}{$album->name}{/if}"
                                 class="pshowgallery-image img-responsive">
                        </a>
                    </div>
                {/foreach}
            </div>

            <section class="popup-album-list-item-container">
                <div class="close-box">
                    <i class="material-icons">close</i>
                </div>
                <div class="popup-album-list-item">
                    {foreach from=$images item='image'}
                        <div class="popup-album-single-item">
                            <img itemprop="image"
                                 src="{$img_pub_path}{$image['id_pshow_gallery_image']}.{$image['extension']}"
                                 title="{if $image['description']}{$image['description']}{else}{$album->name}{/if}"
                                 alt="{if $image['description']}{$image['description']}{else}{$album->name}{/if}"
                                 class="pshowgallery-image img-responsive">
                        </div>
                    {/foreach}
                </div>
            </section>
        </div>
    {/if}

{/block}

{block name='javascript_bottom'}
    {$smarty.block.parent}
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
    <script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
{/block}
