<div id="product-images" class="panel product-tab">
	<input type="hidden" name="submitted_tabs[]" value="Images" />
	<div class="panel-heading tab" >
		{l s='Images' mod='pshowgallery'}
		<span class="badge" id="countImage">{$imagesCount}</span>
	</div>
	
	<!-- BEGIN drop box -->
	<div id="dragandrophandler" class="pshowgallery">
	
		<div class="row">
			<div class="form-group">			
				<input type="file" class="fileSelector form-control" multiple>
				<input type="hidden" name="id_album" value="{$id_pshow_gallery_album}">

				<div class="drop-info">
					<div class="col-xs-4 col-xs-offset-4">
						{l s='Drop files here or click to select files to upload' mod='pshowgallery'}
					</div>
					<div class="clearfix"></div>
				</div>				
			</div>
			<div class="loader"></div>
		</div>
		
		<table class="table tableDnD" id="imageTable">
			<thead>
				<tr class="nodrag nodrop">
					<th class="fixed-width-sm"><span class="title_box">{l s='Image' mod='pshowgallery'}&nbsp;<i class="icon_empty"></i></span></th>
					<th class=""><span class="title_box">{l s='Description' mod='pshowgallery'}&nbsp;<i class="icon_empty"></i></span></th>
					<th class="fixed-width-xs" id="table_order"><span class="title_box">{l s='Order' mod='pshowgallery'}&nbsp;<i class="icon_sort_order"></i></span></th>
					<th class="fixed-width-xs"><span class="title_box">{l s='Album cover' mod='pshowgallery'}&nbsp;<i class="icon_empty"></i></span></th>
					<th class="fixed-width-xs"><span class="title_box">{l s='Visible' mod='pshowgallery'}&nbsp;<i class="icon_empty"></i></span></th>
					<th class="fixed-width-xs"><span class="title_box">{l s='Code' mod='pshowgallery'}&nbsp;<i class="icon_empty"></i></span></th>
					<th class="fixed-width-xs" id="table_date"><span class="title_box">{l s='Data dodania' mod='pshowgallery'}&nbsp;<i class="icon_sort_date"></i></span></th>
					<th></th> <!-- action -->
				</tr>
			</thead>
			<tbody id="imageList">
			</tbody>
		</table>
		<table id="lineType" style="display:none;">
			<tr id="image_id">
				<td>
					<div class="gallery_thumb img-thumbnail" style="background-image: url(image_path)">
					<img
						src="image_path"
						alt="description"
						title="description" />
				</td>
				<td>
					<div class="row">
						{foreach from=$languages item=language}
							<div class="translatable-field lang-{$language.id_lang}">
								<div class="col-lg-8">
									<input type="text" id="description_{$language.id_lang}" name="description_{$language.id_lang}" value="value_description_{$language.id_lang}">
								</div>
								<div class="col-lg-2">
									<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" tabindex="-1">
										{$language.iso_code}
										<span class="caret"></span>
									</button>
									<ul class="dropdown-menu">
										{foreach from=$languages item=language}
										<li>
											<a href="javascript:hideOtherLanguage({$language.id_lang});">{$language.name}</a>
										</li>
										{/foreach}
									</ul>
								</div>
								
							</div>
						{/foreach}
						
						<div class="col-lg-2">
							<a href="#" title="{l s='Save' mod='pshowgallery'}" class="btn btn-default save_description">
								<i class="icon-pencil"></i>
							</a>
						</div>
					</div>
				</td>
				<td id="td_image_id" class="pointer dragHandle center positionImage">
					<div class="dragGroup">
						<div class="positions">
							image_position
						</div>
					</div>
				</td>
				<td class="cover center">
					<a href="#">
						<i class="icon-check-empty icon-2x covered"></i>
					</a>
				</td>
				<td class="center">
					<a href="#" class="visible_image list-action-enable action-enabled">
						<i class="status-icon-check"></i>
					</a>
				</td>
				<td class="center">
					<a href="#" title="{l s='Copy code' mod='pshowgallery'}" class="btn btn-default getcode"
					   onclick="fancyMsgBox('{l s='Code to paste in template' mod='pshowgallery'}: {literal}{hook h=\'PShowGalleryGetImages\' id_image=\'image_id\'}{/literal}');">
						<i class="icon-code"></i>
					</a>
				</td>
				<td class="center">
					<div class="dates">
						image_date_add
					</div>
				</td>
				<td>
					<a href="#" class="delete_image pull-right btn btn-default">
						<i class="icon-trash"></i> {l s='Delete this image' mod='pshowgallery'}
					</a>
				</td>
			</tr>
		</table>
	
	<!-- END drop box -->
	</div>
	
</div>

<script type="text/javascript">
	hideOtherLanguage(default_language);
	
	function imageLine(id, path, position, cover, description, active, date_add)
	{
		line = $("#lineType").html();
		line = line.replace(/image_id/g, id);
		line = line.replace(/image_path/g, path);
		line = line.replace(/image_position/g, position);

		$.each(description, function(key, value) {
			line = line.replace('value_description_' + key, value);
		});
		
		if (cover)
			line = line.replace(/icon-check-empty/g, "icon-check-sign");
		
		if (!active)
		{
			line = line.replace(/action-enabled/g, "action-disabled");
			line = line.replace(/status-icon-check/g, "icon-remove");
		}
		else
			line = line.replace(/status-icon-check/g, "icon-check");
		
		line = line.replace(/image_date_add/g, date_add);
		line = line.replace(/<tbody>/gi, "");
		line = line.replace(/<\/tbody>/gi, "");
		
		$("#imageList").append(line);
	}
	
	function refreshImagePositions(imageTable)
	{
		imageTable.find("tbody tr").each(function(i,el) {
			$(el).find("td.positionImage .positions").html(i + 1);
		});
	}
	
	function refreshVisible(link)
	{
		if (link.hasClass('action-disabled'))
			link.removeClass('action-disabled').addClass('action-enabled')
				.children().removeClass('icon-remove').addClass('icon-check');
		else
			link.removeClass('action-enabled').addClass('action-disabled')
				.children().removeClass('icon-check').addClass('icon-remove');
	}
	
	function refreshCover(link)
	{
		$("#imageList .cover i").each( function(i)
		{
			$(this).removeClass('icon-check-sign').addClass('icon-check-empty');
		});
		
		$(link).removeClass('icon-check-empty').addClass('icon-check-sign');
		$(link).parent().parent().parent().children('td input').attr('check', true);
	}
</script>
