<?php

/**
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 *  @authors     PrestaShow.pl <kontakt@prestashow.pl>
 *  @copyright   2016 PrestaShow.pl
 *  @license     http://PrestaShow.pl/license
 */

namespace Prestashow\PShowGallery\Controller;

use Prestashow\PrestaCore\Model\AbstractAdminController;
use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Entity\PShowGalleryImage;
use Db;
use Language;
use Tools;
use Context;
use Validate;

class AlbumController extends AbstractAdminController
{
    public $default_action = 'list';
    public $select_menu_tab = 'subtab-PShowGalleryAlbum';
    
    protected $position_identifier = 'id_pshow_gallery_album';
    
    public function __construct()
    {
        $this->table = 'pshow_gallery_album';
        $this->className = '\Prestashow\PShowGallery\Entity\PShowGalleryAlbum';
        $this->lang = true;
        $this->_defaultOrderBy = 'position';
        $this->_defaultOrderWay = 'ASC';
        
        $this->context = Context::getContext();
        
        parent::__construct();
        
        $this->controller_displayName = $this->l('Albums');
        $this->toolbar_title = $this->l('Albums');
        
        $this->specificConfirmDelete = $this->l('Delete this album?');
        
        $this->fields_list = array(
            'id_pshow_gallery_album' => array(
                'title' => $this->l('ID'),
                'align' => 'center',
                'class' => 'fixed-width-xs'
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'filter_key' => 'b!name'
            ),
            'count' => array(
                'title' => $this->l('Images'),
                'class' => 'fixed-width-xs',
                'align' => 'center',
            ),
            'position' => array(
                'title' => $this->l('Position'),
                'position' => 'position',
                'align' => 'center',
                'class' => 'fixed-width-sm',
            ),
            'active' => array(
                'title' => $this->l('Displayed'),
                'active' => 'status',
                'type' => 'bool',
                'class' => 'fixed-width-xs',
                'align' => 'center',
                'ajax' => true
            )
        );
        
        $this->addRowAction('images');
        $this->addRowAction('edit');
        $this->addRowAction('code');
        $this->addRowAction('delete');
        
        $this->tpl_folder = 'galleryalbum/';
    }
    
    public function getList($id_lang, $order_by = null, $order_way = null, $start = 0, $limit = null, $id_lang_shop = false)
    {
        parent::getList($id_lang, $order_by, $order_way, $start, $limit, $id_lang_shop);
        
        foreach ($this->_list as &$list)
            $list['count'] = PShowGalleryImage::getImagesCount($id_lang, $list['id_pshow_gallery_album']);
    }
    
    public function postProcess()
    {
        if (Tools::isSubmit('submitAdd' . $this->table))
        {
            $_POST['position'] = (int) Db::getInstance()->getValue("SELECT `position` FROM `" . _DB_PREFIX_ . "pshow_gallery_album` ORDER BY `position` DESC");
            $_POST['position']++;
            
            $languages = Language::getLanguages(true);
            $obj = $this->loadObject(true);
            
            if (Validate::isLoadedObject($obj))
            {
                $this->updateTags($languages, $obj->id);
            }
        }
        
        parent::postProcess();
    }
    
    public function renderList()
    {
        $this->action_displayName = $this->l('Albums');
        
        return parent::renderList();
    }
    
    public function displayImagesLink($token = null, $id, $name = null)
    {
        $tpl = $this->createTemplate('helpers/list/list_action_images.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink('PShowGalleryImage')
            . '&id_pshow_gallery_album=' . $id,
            'action' => $this->l('Images'),
            'id' => $id
        ));
        
        return $tpl->fetch();
    }
    
    public function displayCodeLink($token = null, $id, $name = null)
    {
        $tpl = $this->createTemplate('helpers/list/list_action_album_code.tpl');
        $tpl->assign(array(
            'href' => '',
            'action' => $this->l('Code'),
            'id' => $id
        ));
        
        return $tpl->fetch();
    }
    
    public function ajaxProcessStatusPShowGalleryAlbum()
    {
        if (!$id_album = (int)Tools::getValue('id_pshow_gallery_album'))
            die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('Failed to update the status'))));
            else
            {
                $album = new PShowGalleryAlbum((int)$id_album);
                if (Validate::isLoadedObject($album))
                {
                    $album->active = $album->active == 1 ? 0 : 1;
                    $album->save() ?
                    die(Tools::jsonEncode(array('success' => true, 'text' => $this->l('The status has been updated successfully')))) :
                    die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('Failed to update the status'))));
                }
            }
    }
    
    public function ajaxProcessUpdatePositions()
    {
        $way = (int)(Tools::getValue('way'));
        $id_album = (int)(Tools::getValue('id'));
        $positions = Tools::getValue($this->table);
        
        foreach ($positions as $position => $value)
        {
            $pos = explode('_', $value);
            
            if (isset($pos[2]) && (int)$pos[2] === $id_album)
            {
                if ($album = new PShowGalleryAlbum((int)$pos[2])) {
                    if (isset($position) && $album->updatePosition($way, $position)) {
                        die(true);
                    } else {
                        die('{"hasError" : true, "errors" : "Can not update album ' . (int)$id_album . ' to position ' . (int)$position . ' "}');
                    }
                } else {
                    die('{"hasError" : true, "errors" : "This album (' . (int)$id_album . ') can t be loaded"}');
                }
                
                break;
            }
        }
    }
    
    public function renderForm()
    {
        $this->action_displayName = $this->l('Edit Album');
        
        $obj = $this->loadObject(true);
        
        $active_input_type = 'switch';
        
        if (version_compare(_PS_VERSION_, '1.6', '<'))
            $active_input_type = 'radio';
            
            $this->fields_form = array(
                'tinymce' => true,
                'legend' => array(
                    'title' => $this->l('Album')
                ),
                'input' => array(
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Displayed'),
                        'name' => 'active',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Name'),
                        'name' => 'name',
                        'lang' => true,
                        'required' => true,
                        'size' => 48,
                        'id' => 'name', // for copy2friendlyUrl
                        'class' => 'copy2friendlyUrl',
                        'hint' => $this->l('Invalid characters:').' &lt;&gt;;=#{}'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Friendly URL'),
                        'name' => 'link_rewrite',
                        'required' => true,
                        'lang' => true,
                        'hint' => $this->l('Only letters and the minus (-) character are allowed.')
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Description'),
                        'name' => 'description',
                        'required' => true,
                        'autoload_rte' => true,
                        'lang' => true,
                        'rows' => 10,
                        'cols' => 100
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Tags'),
                        'name' => 'tags',
                        'size' => 60,
                        'lang' => true,
                        'required' => false,
                        'hint' => $this->l('Enter Your Entry Meta Tag. Separated by comma(,)')
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save')
                )
            );
            
            if (Validate::isLoadedObject($obj))
            {
                foreach (Language::getLanguages(true) as $lang)
                {
                    $this->fields_value['tags'][(int)$lang['id_lang']] = PShowGalleryAlbum::getTagsBylang($obj->id, (int)$lang['id_lang']);
                }
            }
            
            return parent::renderForm();
    }
    
    public function updateTags($languages, $id_album)
    {
        $tag_success = true;
        if (!PShowGalleryAlbum::deleteTagsForAlbum((int)$id_album))
            $this->errors[] = Tools::displayError('An error occurred while attempting to delete previous tags.');
            
            foreach ($languages as $language)
            {
                if ($value = Tools::getValue('tags_'.$language['id_lang']))
                {
                    $tag_success &= PShowGalleryAlbum::addTags($language['id_lang'],(int)$id_album, $value);
                }
            }
            
            if (!$tag_success)
            {
                $this->errors[] = Tools::displayError('An error occurred while adding tags.');
            }
            
            return $tag_success;
    }
    
    // Temporary bypass functions
    public function listHelperAction() {}
    public function addHelperAction() {}
    public function editHelperAction() {}
}
