<?php

/**
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 *  @authors     PrestaShow.pl <kontakt@prestashow.pl>
 *  @copyright   2016 PrestaShow.pl
 *  @license     http://PrestaShow.pl/license
 */
namespace Prestashow\PShowGallery\Entity;

use Prestashow\PrestaCore\Model\AbstractEntity;
use Hook;
use Db;
use ObjectModel;

class PShowGalleryHook extends AbstractEntity
{
    /** @var int ID */
    public $id_pshow_gallery_bhook;

	/** @var int */
    public $presta_id_hook;

    /** @var string */
    public $hook_name;
	
	/** @var string */
    public $hook_type;

    /** @var int */
    public $id_album;
	
	/** @var int */
    public $id_image;
	
    /** @var int */
    public $limit;

    /** @var string Title */
    public $title;
    
    /** @var string */
    public $albums;
    
    /** @var string */
    public $list_type;
    
    /** @var int */
    public $thumb_cols;
    
    /** @var int columns_width_xs */
    public $columns_width_xs;
    
    /** @var int columns_width_sm */
    public $columns_width_sm;
    
    /** @var int columns_width_md */
    public $columns_width_md;
    
    /** @var int columns_width_lg */
    public $columns_width_lg;
	
	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'pshow_gallery_hook',
        'primary' => 'id_pshow_gallery_hook',
        'multilang' => true,
        'multilang_shop' => false,
        'fields' => array(
			'presta_id_hook' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'hook_name' => array('type' => self::TYPE_STRING, 'required' => true),
			'hook_type' => array('type' => self::TYPE_STRING, 'required' => true),
            'id_album' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'id_image' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'limit' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
        	'albums' => array('type' => self::TYPE_STRING),
        	'list_type' => array('type' => self::TYPE_STRING),
            'thumb_cols' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'columns_width_xs' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'columns_width_sm' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'columns_width_md' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'columns_width_lg' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),

            'title' => array('type' => self::TYPE_HTML, 'lang' => true, 'size' => 264, 'validate' => 'isCleanHtml')
        ),
    );
	
	public function __construct($id_hook = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_hook, $id_lang, $id_shop);
		
		self::$definition['table'] = 'pshow_gallery_hook';
    }
	
	public static function getHooks($type = null)
    {
        
        $q = "SELECT * FROM `" . _DB_PREFIX_ . self::$definition['table'] . "` h";
		
		if ($type != null)
            $q .= " WHERE h.`hook_type` = '" . pSQL($type) . "'";

        return Db::getInstance()->executeS($q);
    }
	
	public static function getIdImageByIdAlbum($id_album)
	{
		$q = "SELECT h.`id_image` FROM `" . _DB_PREFIX_ . self::$definition['table'] . "` h
			WHERE h.`id_album` = " . (int) $id_album;
			
		return Db::getInstance()->getValue($q);
	}

    public static function getHookIdByPrestaHookId($presta_id_hook)
    {
        
        $q = "SELECT h.`id_pshow_gallery_hook` FROM `" . _DB_PREFIX_ . self::$definition['table'] . "` h
			WHERE h.`presta_id_hook` = " . (int) $presta_id_hook;

        return Db::getInstance()->getValue($q);
    }

    public static function getHookIdByPrestaHookName($presta_hook_name)
    {
        $hook_id = Hook::getIdByName($presta_hook_name);

        return self::getHookIdByPrestaHookId($hook_id);
    }

    public static function countHooks($type = null)
    {
        
        $q = "SELECT COUNT(*) FROM `" . _DB_PREFIX_ . self::$definition['table'] . "` h";
		
		if ($type != null)
            $q .= " WHERE h.`hook_type` = '" . pSQL($type) . "'";

        $query = Db::getInstance()->getValue($q);

        if ($query === false)
            return false;

        return $query;
    }
}