{extends file="helpers/form/form.tpl"}

{block name="field"}
    {if $input.type == 'album_images'}
        <div id="album_images" class="col-xs-9"><div class="row"></div></div>
		<style>
			#album_images label {
				float: right;
				width: 85%;
				cursor: pointer;
			}
			#album_images img {
				border: 1px #E6E6E6 solid;
			}
		</style>
    {else}
        {$smarty.block.parent}
    {/if}
{/block}

{block name=script}
	var token = '{$token}';
	var img_pub_path = '{$img_pub_path}';
	var images_limit_box = $('#limit').parent();
	var images_limit_label = $(images_limit_box).prev();
	var id_image_box = $('#album_images');
	var id_image_label = $(id_image_box).prev();
	var id_album = $("#id_album").parent().parent();
	var checkbox_albums = $("input.albums-categories").parent().parent().parent().parent();
	var thumb_cols = $("#thumb_cols").parent().parent();
	var list_type = $("#list_type").parent().parent();
	
	$(document).ready(function() 
	{
		ajaxImages($('#id_album').val());
		
		if ($('#hook_type').val() == 'album')
			hookTypeAlbum();
		else if ($('#hook_type').val() == 'albums')
			hookTypeAlbums();
		else if ($('#hook_type').val() == 'image')
			hookTypeImage();
		
		$('#hook_type').on('change', function()
		{
			var value = $(this).val();
			
			if (value == 'album')
				hookTypeAlbum();
			else if (value == 'albums')
				hookTypeAlbums();
			else if(value == 'image')
				hookTypeImage();
		});
		
		$('#id_album').on('change', function()
		{
			$('input[name="id_image"]').attr('checked', false);
			ajaxImages($(this).val());
		});
	});
	
	function hookTypeAlbum()
	{
		$(id_image_box).hide();
		$(id_image_label).hide();
		$(images_limit_box).show();
		$(images_limit_label).show();
		$(id_album).show();
		$(checkbox_albums).hide();
		$(thumb_cols).show();
		$(list_type).show();
	}
	
	function hookTypeAlbums()
	{
		$(id_image_box).hide();
		$(id_image_label).hide();
		$(images_limit_box).hide();
		$(images_limit_label).hide();
		$(id_album).hide();
		$(checkbox_albums).show();
		$(thumb_cols).hide();
		$(list_type).hide();
	}
	
	function hookTypeImage()
	{
		$(images_limit_box).hide();
		$(images_limit_label).hide();
		$(id_image_box).show();
		$(id_image_label).show();
		$(id_album).show();
		$(checkbox_albums).hide();
		$(thumb_cols).show();
		$(list_type).show();
	}
	
	function ajaxImages(value)
	{
		$(id_image_box).find('.row').empty().hide();
		
		$.ajax(
		{
			url: currentIndex + '&token=' + token + '&ajax=' + 1,
			method: 'POST',
			async: true,
			dataType: 'json',
			data: {
				'ajax': true,
				'id_album': value
			},
			success: function(data)
			{
				if (data.images.length > 0)
				{
					data.images.forEach(function(item)
					{
						var html = 
							'<div class="col-xs-2">' + 
								'<input type="radio" id="id_image_' + item.id  + '" name="id_image" value="' + item.id + '"' +
								((data.checked != null && data.checked == item.id) ? 'checked="checked"' : '') + ' />' +
								'<label for="id_image_' + item.id  + '">' +
									'<img class="img-responsive" src="' + img_pub_path + 'thumb_' + item.id + '.jpg">' +
								'</label>' +
							'</div>';
							
						$(id_image_box).find('.row').append(html);
					});
					
					$(id_image_box).find('.row').show();
				}
			}
		});
	}
{/block}
	