<?php

/*
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 *  @authors     PrestaShow.pl <kontakt@prestashow.pl>
 *  @copyright   2020 PrestaShow.pl
 *  @license     https://prestashow.pl/license
 */

namespace Prestashow\PShowGallery\Entity;

use Prestashow\PrestaCore\Model\AbstractEntity;

class Item extends AbstractEntity
{

    /**
     * {@inheritDoc}
     */
    public $repositoryClass = '\\Prestashow\\PShowGallery\\Repository\\ItemRepository';

    /**
     * @var string
     */
    public $name;

    /**
     * Object creation date
     *
     * @var string
     */
    public $date_add;

    /**
     * {@inheritDoc}
     */
    public static $definition = array(
        'table' => 'pshow_item',
        'primary' => 'id',
        'fields' => array(
            'name' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'size' => 128,
            ),
            'date_add' => array(
                'type' => self::TYPE_DATE,
                'validate' => 'isDate'
            ),
        ),
    );

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $content
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDateAdd(): string
    {
        return $this->date_add;
    }

}
