<?php

require_once dirname(__FILE__) . "/../../config.php";

use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Model\Module as PShowGallery;
use Configuration;

class PShowGalleryAlbumsModuleFrontController extends ModuleFrontController
{
    public $simple_show;

    public function init()
    {
        parent::init();

        $this->simple_show = Configuration::get('PSHOW_GALLERY_SIMPLE_SHOW');
        $this->display_column_right = Configuration::get('PSHOW_GALLERY_RIGHT_COLUMN');
    }

    public function initContent()
    {
        parent::initContent();

        $albums = PShowGalleryAlbum::getAlbums($this->context->language->id, $this->context->shop->id, true);
        $ids_albums = array();
        foreach ($albums as &$album) {
            $ids_albums[] = $album->id_pshow_gallery_album;
        }

        $gallery_page_name = Configuration::get('PSHOW_GALLERY_PAGE_NAME', $this->context->language->id);

        $ssl = Configuration::get('PS_SSL_ENABLED');
        $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
        $img_pub_path = $base . _PS_IMG_ . PShowGallery::GALLERY_IMAGE;
        $mobile_device = $this->context->getMobileDevice();

        $this->context->smarty->assign(array(
            'meta_title' => $gallery_page_name,
            'albums' => implode(",", $ids_albums),
            'simple_show' => $this->simple_show,
            'img_pub_path' => $img_pub_path,
            'gallery_page_name' => $gallery_page_name,
            'path' => $gallery_page_name,
            'mobile_device' => $mobile_device
        ));

        if (version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->setTemplate('module:pshowgallery/views/templates/front/albums_new_presta.tpl');
        } else {
            $this->setTemplate('albums.tpl');
        }
    }
}
